/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
    'jquery',
    'Magento_Customer/js/model/authentication-popup',
    'Magento_Customer/js/customer-data'
], function ($, authenticationPopup, customerData) {
    'use strict';

    return function (config, element) {
        $(element).on('click', function (event) {
            var cart = customerData.get('cart'),
                customer = customerData.get('customer');

            event.preventDefault();

            if (!customer().firstname && cart().isGuestCheckoutAllowed === false) {
                authenticationPopup.showModal();

                return false;
            }
            //  var popupFeatures = 'width=800,height=600,scrollbars=yes,resizable=yes';
            //  var checkoutPopup = window.open(config.checkoutUrl, 'Checkout', popupFeatures);
            //  if (checkoutPopup) {
            //     checkoutPopup.focus();
            // } else {
            //     alert('Popup blocked. Please allow popups for this website.');
            // }
            $.magnificPopup.open({
                items: {
                    src: config.checkoutUrl, // URL of the checkout page
                    type: 'iframe'
                },
                iframe: {
                    patterns: {
                        example: {
                            index: 'example.com',
                            src: config.checkoutUrl
                        }
                    }
                },
                type: 'iframe',
                closeOnContentClick: false,
                closeBtnInside: true,
                fixedContentPos: true,
                removalDelay: 300,
                mainClass: 'mfp-fade'
            });
            $(element).attr('disabled', true);
            //location.href = config.checkoutUrl;
        });

    };
});
